// sp_control
// cntrl thinks
#include "g_local.h"
int ctrlmdl[3];

void Power_Overlay ()
{
	// 
	char str[256], 
		mk0[10], mk1[10], mk2[10],
		rgb0[3], rgb1[3], rgb2[3];
	if (power.markers[0] && power.markers[1] && power.markers[2])
	{
		if (ctrlmdl[0] == power.markers[0]->s.modelindex)
		{
			strcpy(mk0, "markx");
			strcpy(rgb0, "888");

		}
		else if (ctrlmdl[1] == power.markers[0]->s.modelindex)
		{
			strcpy(mk0, "markr");
			strcpy(rgb0, "811");
		}
		else if (ctrlmdl[2] == power.markers[0]->s.modelindex)
		{
			strcpy(mk0, "markb");
			strcpy(rgb0, "118");
		}

		if (ctrlmdl[0] == power.markers[1]->s.modelindex)
		{
			strcpy(mk1, "markx");
			strcpy(rgb1, "888");

		}
		else if (ctrlmdl[1] == power.markers[1]->s.modelindex)
		{
			strcpy(mk1, "markr");
			strcpy(rgb1, "811");
		}
		else if (ctrlmdl[2] == power.markers[1]->s.modelindex)
		{
			strcpy(mk1, "markb");
			strcpy(rgb1, "118");
		}

		if (ctrlmdl[0] == power.markers[2]->s.modelindex)
		{
			strcpy(mk2, "markx");
			strcpy(rgb2, "888");
		}
		else if (ctrlmdl[1] == power.markers[2]->s.modelindex)
		{
			strcpy(mk2, "markr");
			strcpy(rgb2, "811");
		}
		else if (ctrlmdl[2] == power.markers[2]->s.modelindex)
		{
			strcpy(mk2, "markb");
			strcpy(rgb2, "118");
		}
		sprintf(str, "xl 10 yt 30 dmstr %s \"%s\" "
					 "yt 110 dmstr %s \"%s\" "
					 "yt 190 dmstr %s \"%s\" "
					 "xl 20 yt 50 picn %s "
					 "xl 20 yt 130 picn %s "
					 "xl 20 yt 210 picn %s ",
					 rgb0, power.markers[0]->name,
					 rgb1, power.markers[1]->name,
					 rgb2, power.markers[2]->name,
					 mk0, mk1, mk2);

	//	gi.dprintf("%s\n", str);
		gi.WriteByte (svc_layout);
		gi.WriteString (str);	
	}
}

void ControlThink (edict_t *self)
{
	// What about cash spawning?
	// Give score
	if (level.intermissiontime)
		return;

	if(self->CollectDelay > 0)
		self->CollectDelay--;

	if ( self->s.modelindex == ctrlmdl[1] )
	{
		power.teamscore[1]++;
		if(power.teamscore[1] > 9999)
			power.teamscore[1] = 0;

//		if (developer->value)
//			gi.dprintf("add score team 1: %d from marker %d\n", power.teamscore[1], self->count);
	}

	if ( self->s.modelindex == ctrlmdl[2] )
	{
		power.teamscore[2]++;
		if(power.teamscore[2] > 9999)
			power.teamscore[2] = 0;
//		if (developer->value)
//			gi.dprintf("add score team 2: %d from marker %d\n", power.teamscore[2], self->count);
	}

	self->nextthink = level.time + 1;
}
void control_point_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	if(self->CollectDelay > 0)
		return;

	if (other->leader)
		other = other->leader;

	if (!other->client)
		return;

	if (self->s.modelindex == ctrlmdl[other->client->pers.team])
		return;// already owned

//CDEATH
//END CDEATH

/*	if (other->client->pers.team == 1)
	{
		if (developer->value)
			gi.dprintf("DEBUG: touch team 1\n");
	}
	else if (other->client->pers.team == 2)
	{
		if (developer->value)
			gi.dprintf("DEBUG: touch team 2\n");
	}*/

//	gi.dprintf("TODO: give score/cash to %s\n", other->client->pers.netname);
	self->CollectDelay = 5;//4 = 20 secs since thinktime is in seconds - 5 * 4 = 20
	other->client->pers.currentcash += marker_award->value;
	CheckMaxCash(other);

//	gi.bprintf(PRINT_MEDIUM, "switched %s\n", other->client->pers.netname);
	// give score if it changed team
	self->s.modelindex = ctrlmdl[other->client->pers.team];

	self->nextthink = level.time + 1;//maybe change this?
	gi.linkentity (self);

	Power_Overlay();
	gi.multicast (self->s.origin, MULTICAST_ALL);

}

void SP_ControlPoint (edict_t *self)
{
//	gi.dprintf("Control Spawned\n");

	if(strcmp(level.mapname, "power_docks") == 0)
	{
		if(strncmp(self->name, "Center of the map", 17) == 0)
			strcpy(self->name, "Tunnel");
		if(strncmp(self->name, "In building", 11) == 0)
			strcpy(self->name, "Wood Room");
		if(strncmp(self->name, "In warehouse", 12) == 0)
			strcpy(self->name, "Warehouse Office");
	}
	else
		if(strcmp(level.mapname, "power_iraq") == 0)
		{
			if(strncmp(self->name, "Center of the map", 17) == 0)
				strcpy(self->name, "Central Fort");
			if(strcmp(self->name, "Behind Tank") == 0)
				strcpy(self->name, "Tank");
			if(strncmp(self->name, "in building", 11) == 0)
				strcpy(self->name, "Command Centre");
		}

	
	if (power.num_control_points == 0)
	{
		// precache
		ctrlmdl[0]=gi.modelindex ("models/m3.md2");
		ctrlmdl[1]=gi.modelindex ("models/m1.md2");
		ctrlmdl[2]=gi.modelindex ("models/m2.md2");
	}
	else if (power.num_control_points >= MAX_CONTROL_POINTS)
	{
		if (developer->value)
			gi.dprintf("DEBUG: Cant add any more markers\n");
		return;
	}

	self->model = "models/m3.md2";
	self->s.effects = EF_ROTATE;
	VectorSet (self->mins, -16, -16, -24);// As big as player
	VectorSet (self->maxs, 16, 16, 48);
	self->s.renderfx = RF_GLOW;
	self->s.modelindex = ctrlmdl[0];
	self->touch = control_point_touch;
	self->solid = SOLID_TRIGGER;
	self->think = ControlThink;
	self->count = power.num_control_points;
	self->CollectDelay = 0;

/*	if (!self->name)
	{
		self->name = malloc(30);
		sprintf(self->name, "Marker %d", power.num_control_points);
	}
*/
	power.markers[power.num_control_points++] = self;
	
	gi.linkentity (self);
//	KillBox(self);
}

extern void ED_CallSpawn (edict_t *ent);
void Cmd_testcontrol_f (edict_t *ent)
{
	edict_t	*control;	
	vec3_t	forward, right, offset;
	trace_t	trace;

	control = G_Spawn();
	control->think = ED_CallSpawn;//SP_ControlPoint;
	control->nextthink = level.time + 1;
	strcpy(control->classname, "power_control_point");

	AngleVectors (ent->client->v_angle, forward, right, NULL);
	VectorSet(offset, 24, 0, -16);
	G_ProjectSource (ent->s.origin, offset, forward, right, control->s.origin);
	trace = gi.trace (ent->s.origin, control->mins, control->maxs,
		control->s.origin, ent, control->clipmask);
	VectorCopy (trace.endpos, control->s.origin);

	control->s.origin[2]+=30;

	gi.linkentity (control);
}

void ControlDeathRules (edict_t *target, edict_t *attacker)
{
	edict_t *find = NULL;

	while (find = findradius( find, target->s.origin, 128 ))
	{
		if (find == target)
			continue;

		if (!visible(find, target))
			continue;

		if (find->s.modelindex != ctrlmdl[attacker->client->pers.team])
			continue;
		
		if (Q_stricmp ("power_control_point", find->classname) == 0)
		{
			// todo award bonuses
			gi.bprintf (PRINT_HIGH, "%s defends a Control Point.\n", attacker->client->pers.netname);
			return;
		}
	}
}

void PowerControlPoints(void)
{
	char		file_name[256];
	char		name[64];
	cvar_t		*game_dir;
	FILE *fp;
	game_dir = gi.cvar ("game", "", 0);	

	return ;
#ifdef UNIX
	sprintf(file_name, "./%s/ents/%s.markers", game_dir->string, level.mapname); 
#else
	sprintf(file_name, ".\\%s\\ents\\%s.markers", game_dir->string, level.mapname);
#endif

	if (fp = fopen(file_name, "r")) 
	{
		int i;
		for (i = 0; i < MAX_CONTROL_POINTS; i++)
		{
			vec3_t pos;
//			char *ptr;
			fgets(name, 64, fp);
		//	strtok(
			//fscanf(fp, "%s %f %f %f\n", name, &pos[0], &pos[1], &pos[2]);
			gi.dprintf("%s %f %f %f\n", name, pos[0], pos[1], pos[2]);
		}
		fclose(fp);
	}
}